set print=off.
set errors=none.

DATA LIST free
/alpha (f10.5) mdiff (f10.5)  sd (f10.5)  power (f10.5) ratio (f10.5). 
BEGIN DATA. 
0.05 6.0 10.0 0.90 1
0.05 3.0 4.0 0.90 1
0.05 6.0 10.0 0.90 2
END DATA. 

define unpairt (!pos !tokens(1)
                   / !pos !tokens(1)
                   / !pos !tokens(1)
                   / !pos !tokens(1)
                   / !pos !tokens(1)).
COMPUTE #POW = !4.
compute #conf = (1-!1/2).
compute #lc3 = 1.
compute #ind=0.
compute n1 = 20.
comment COMPUTE #LC1 = 2.000.
COMPUTE #CUMF2 = 1-ncdf.t(idf.t(#conf,n1+(!5*n1)-2),n1+(!5*n1)-2,(!2)/sqrt(!3*!3/n1+!3*!3/(n1*!5))).
COMPUTE #DIFF = 10 .
SET MXLOOPS=10000.
LOOP IF (#DIFF GT .00005) .
+       DO IF (#CUMF2 LT #pow) .
+               COMPUTE #LC3 = N1 .
+               COMPUTE N1 = (N1 + 0.5).
+               COMPUTE #CUMF2 =  1-ncdf.t(idf.t(#conf,n1+(!5*n1)-2),n1+(!5*n1)-2,(!2)/sqrt(!3*!3/n1+!3*!3/(n1*!5))).

+       ELSE .
+               COMPUTE #LC1 = n1 .
+               COMPUTE n1 = (n1 - 0.5) .
+               COMPUTE #CUMF2 = 1-ncdf.t(idf.t(#conf,n1+(!5*n1)-2),n1+(!5*n1)-2,(!2)/sqrt(!3*!3/n1+!3*!3/(n1*!5))).
+       END IF .
+       COMPUTE #DIFF = ABS(#CUMF2 - #pow) .
END LOOP .
compute #pow2 = 1-ncdf.t(idf.t(#conf,n1+(!5*n1)-2),n1+(!5*n1)-2,(!2)/sqrt(!3*!3/n1+!3*!3/(n1*!5))).
compute #differ=abs(#pow-#pow2).
if (n1-trunc(n1) gt 0.5) #ind=1.
if (#ind eq 0) n1=trunc(n1)+1.
if (#ind eq 1) n1=rnd(n1).
EXECUTE .
compute alpha=!1.
compute mdiff=!2.
compute sd=!3.
compute power=!4.
compute n2=!5*n1.
formats n1 (f7.0) n2 (f7.0) ratio (f7.2) alpha (f5.2) mdiff (f5.2) sd (f5.2) power (f5.2).
variable labels n1 'Sample 1 Required' /n2 'Sample 2 Required' /ratio 'Ratio n2 to n1' /alpha 'Alpha' /mdiff 'Mean Difference' /sd 'SD' /power 'Power'.
report format=list automatic align(center)
  /variables=n1 n2 ratio alpha mdiff sd power 
  /title "Unpaired t-test for given power assuming unequal groups" .
!enddefine.

matrix.
get m /variables=alpha mdiff sd power ratio /missing=omit.
compute alpha=make(1,1,0).
compute mdiff=make(1,1,0).
compute sd=make(1,1,0).
compute power=make(1,1,0).
compute ratio=make(1,1,0).
compute alpha=m(:,1).
compute mdiff=m(:,2).
compute sd=m(:,3).
compute power=m(:,4).  
compute ratio=m(:,5).
end matrix.
unpairt alpha mdiff sd power ratio.
